#include <iostream>
#include <vector>
#include <set>

using namespace std;

#define ubrzaj ios::sync_with_stdio(false); cin.tie(NULL);
typedef long long ll;

struct NajboljihK
{
    int k_br;
    ll trenutna_suma=0;
    multiset<ll> manji, ostali;

    NajboljihK(int k) : k_br(k) {}

    void dodaj(ll v)
    {
        if(k_br <= 0)
        {
            return;
        }
        manji.insert(v);
        trenutna_suma+=v;
        if (manji.size()>k_br)
        {
            auto it=prev(manji.end());
            trenutna_suma-=*it;
            ostali.insert(*it);
            manji.erase(it);
        }
    }

    void ukloni(ll v)
    {
        if(k_br<=0)
        {
            return;
        }
        auto it=manji.find(v);
        if(it != manji.end())
        {
            trenutna_suma-=v;
            manji.erase(it);
            if (!ostali.empty())
            {
                auto it2=ostali.begin();
                trenutna_suma+=*it2;
                manji.insert(*it2);
                ostali.erase(it2);
            }
        }
        else
        {
            auto it2=ostali.find(v);
            if(it2 != ostali.end())
            {
            ostali.erase(it2);
            }
        }
    }
};

int main()
{
    ubrzaj;
    int n, m, k_kraj;
    cin>>n>>m>>k_kraj;

    vector<ll>a(n+1);
    vector<ll>pref(n+1, 0);
    for(int i=1; i<=n; i++)
    {
        cin>>a[i];
        pref[i]=pref[i-1]+a[i];
    }

    NajboljihK st(k_kraj-1);

    for (int i=1; i<m; i++)
    {
        st.dodaj(pref[i]);
    }

    for(int i=1; i<=n-m+1; i++)
    {
        int l=i;
        int r=i+m-1;

        ll s_prozora=pref[r]-pref[l-1];
        ll rez=s_prozora + (ll)(k_kraj-1) * pref[r] - st.trenutna_suma;

        cout<<rez<<(i==n-m+1 ? "" : " ");

        if(i<=n-m)
        {
            st.ukloni(pref[l]);
            st.dodaj(pref[r]);
        }
    }
    return 0;
}